-- Refresh the VIEW Structure on VoxcoSystem.tblObjects table, required for clients upgrading from previous version where view did not exist
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'tblObjects') 
    DROP View [dbo].[tblObjects] 
GO
create view dbo.tblObjects as select * from #VoxcoSystemDatabaseName#.dbo.tblObjects
GO

-- Refresh the VIEW Structure on VoxcoSystem.tblPages table, required for clients upgrading from previous version where view did not exist
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'tblPages') 
    DROP View [dbo].[tblPages] 
GO
create view dbo.tblPages as select * from #VoxcoSystemDatabaseName#.dbo.tblPages
GO

/*******************************************************************************************************************/
/* This script will read tblpages table to get all kind 1005 entries for each module               */
/* Update Appearance table of database with all 1005 kind entries - 1005 is for CAPI PROJECT                                                 */
/*******************************************************************************************************************/
DECLARE @DbName NVARCHAR(max)
SELECT @DbName = db_name() 

IF EXISTS (SELECT 1 
           FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_TYPE='BASE TABLE'
           AND TABLE_NAME='Appearance') 
BEGIN
/*#VoxcoSystemDatabaseName#*/
	INSERT INTO [dbo].[Appearance] (ModuleId, PropertyName, PropertyValue, modifiedBy, modified) 
	SELECT	O.k_Id AS ModuleId,
			PA.Name AS PropertyName, 
			Case when CAST (isnull(PA.DynamicValue,'') AS nvarchar(max)) = ''
				Then ISNULL(PA.StaticValue,'')
				Else CAST (isnull(PA.DynamicValue,'') AS nvarchar(max)) END AS PropertyValue,
			8 as modifiedBy, 
			getutcdate() as modified
			FROM tblObjects O
			JOIN tblPages PA	ON  PA.k_id = O.k_Id
								AND PA.Kind = 1005
			JOIN tblPages P		ON  P.k_id = O.ParentId
								AND P.kind = 12000
								AND P.Name = 'InterviewerProjectId'
								AND P.StaticValue = substring(@DbName, 15, len(@DbName)-14)
			WHERE not exists (SELECT 1 from [dbo].[Appearance] A where A.ModuleId = O.k_id and A.PropertyName = PA.Name)				
END 
GO

